import numpy as np
from subspace_clustering import K_Subspaces_algo
from subspace_z_alg import Kz_Subspaces_algo
from sklearn import datasets
from sklearn.cluster import KMeans
import time
import cProfile

def test_fit():
    algo = K_Subspaces_algo(2, dim=1)
    points = np.array([[1,1], [100,2], [2,2],[3,3]])
    algo.fit(points)
    score = algo.score(points)
    assert(np.isclose(score,0))
    
    algo_iter = Kz_Subspaces_algo(2, 2, dim=1, lr=1e-3)
    algo_iter.fit2(points, max_reassigns=10, max_sgd=1000)
    score = algo_iter.score(points)
    assert(np.isclose(score, 0,atol=1e-3))

def test_fit_dim2():
    algo = K_Subspaces_algo(2, dim=2)
    points = np.array([[1,1,1], [-5,0,5], [2,0,2], [3,3,3]])
    algo.fit(points)
    score = algo.score(points)
    assert(np.isclose(score,0))
    
    algo_iter = Kz_Subspaces_algo(2, 2, dim=2, lr=1e-3)
    algo_iter.fit2(points, max_reassigns=10, max_sgd=100)
    assert(np.isclose(algo_iter.score(points), 0, atol=1e-3))
    
    algo_1dim = K_Subspaces_algo(2, dim=1)
    algo_1dim.fit(points)
    score_1dim = algo_1dim.score(points)
    assert(score_1dim > 1)
    
def test_dataset():
    start = time.time()
    data = datasets.fetch_covtype().data
    subset = data#[np.random.choice(data.shape[0], -1)]
    algo = K_Subspaces_algo(2, dim=2)
    algo.fit(subset)
    score_baseline = algo.score(subset)
    
    algo_iter = Kz_Subspaces_algo(2, 2, dim=2, lr=1e-3)
    algo_iter.fit2(subset, max_reassigns=10, max_sgd=100)
    score_iter = algo_iter.score(subset)
    print(score_baseline, score_iter)
    print("time: ", time.time() - start)
    assert(np.isclose(score_iter, score_baseline, rtol=0.05))
    